/*---------------------------------------------------------------------------*\

    FILE....: TIMER.C
    TYPE....: WIN32 C++ Function
    AUTHOR..: John Kostogiannis
    DATE....: 14/11/97

      WIN32 version of functions used implement time out timers in C++.


\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdlib.h>
#include <stdio.h>

#include "timer.h"
#include "generic.h"

/*-------------------------------------------------------------------------*\

				CLASS

\*-------------------------------------------------------------------------*/

class VPBTimer{
public:
	long start_time;
	long current_time;	
	USHORT time_out;
	USHORT timer_enable;		//  1= timer disabled
	VPBTimer();
	~VPBTimer();
	void start();
	USHORT check_time_out(USHORT elapsed);
	USHORT check_time_out_ms(ULONG elapsedms);
};

/*-------------------------------------------------------------------------*\

			    INTERFACE MEMBER FUNCTIONS

\*-------------------------------------------------------------------------*/

Timer::Timer(){
	// create and initialise VBPTimer
	vpbtimer = new VPBTimer;
	assert(vpbtimer != NULL);
}

Timer::~Timer(){
	// delete VBPTimer
	delete vpbtimer;
}

void Timer::timer_start(){
	vpbtimer->start_time = GenerictimeGetTime();
	vpbtimer->timer_enable= 0;
}

void Timer::timer_stop(){
	vpbtimer->timer_enable= 1;	// reset (hold) timer
}

void Timer::timer_check_time_out(USHORT elapsed,USHORT *timeout){
			*timeout = vpbtimer->check_time_out(elapsed);
}

void Timer::timer_check_time_out_ms(ULONG elapsedms,USHORT *timeout){
			*timeout = vpbtimer->check_time_out_ms(elapsedms);
}

/*--------------------------------------------------------------------------*\

	FUNCTION.: VPBTimer
	AUTHOR...: John Kostogiannis
	DATE.....: 13/11/97

	Initialises a timer for future time out checks. 

\*--------------------------------------------------------------------------*/

VPBTimer::VPBTimer(){
	time_out = 0;
	current_time = 0;
	start_time = 0;
	timer_enable = 1;	//  1= timer disabled
}

VPBTimer::~VPBTimer(){}

/*--------------------------------------------------------------------------*\

	FUNCTION.: timer_check_time_out
	AUTHOR...: John Kostogiannis
	DATE.....: 3/10/97

	Checks if a specific amout of time has elapsed since a timer was
	created.

\*--------------------------------------------------------------------------*/

USHORT VPBTimer::check_time_out(USHORT elapsed)
{
	long elapsedmsec;				/* time elapsed in msec	*/
	
	if(timer_enable == 0)
	{	
	    elapsedmsec = 1000*elapsed;
    
	    current_time = GenerictimeGetTime();	/* stores current time */

	    if (current_time > (start_time + elapsedmsec))
		return TIME_OUT;
	    else
		return OK;
	}
	else
	{   return OK;  }
}

/*--------------------------------------------------------------------------*\

	FUNCTION.: timer_check_time_out_ms
	AUTHOR...: David Rowe
	DATE.....: 4/3/98

	As above but time specified in ms.

\*--------------------------------------------------------------------------*/

USHORT VPBTimer::check_time_out_ms(ULONG elapsedms)
{
	long elapsedmsec;				/* time elapsed in msec	*/
	
	if(timer_enable == 0)
	{	
	    elapsedmsec = (long)elapsedms;
    
	    current_time = GenerictimeGetTime();	/* stores current time */

    	    if (current_time > (start_time + elapsedmsec))
		return TIME_OUT;
    	    else
		return OK;

	}
	else
	{   return OK;  }	
}
